%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Version 4.0 of CaSAPI - module for admissible belief semantics			     %%%
%%%                                                                                          %%%
%%% Novelty of v4.0: structured arguments can be computed without the requirement of patient %%%
%%% selection function thanks to the use of explicit markings in the lists for P and O       %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Initial setup, loading modules and initializing the dispute derivation                   %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

:-module(admissibleBeliefs,[runAB/3]).

:- use_module(library(lists)). 
:- use_module(helperFunctions).
:- use_module(screenWriting).
:- use_module(selectionFunctions).
:- use_module(ruleChoices).
:- use_module(playerChoices).
:- use_module(argumentChoices).


init(AnnoP,A0) 	:- 	user:toBeProved(P), 
 			user:retractall(arg_number(_)), 
			user:assert(arg_number(1)),
 			findall(	info(	localG(X),
						argN(1),
						attacks(nothing),
						unmarked(P),
						marked([])
				 	),
 					member(X,P), 
					AnnoP), 	
			getAssumptionsAsList(Asm),
			intersectLists(Asm,P,A0), 
			mwrite('Step 0: '),
			writeStructQuad(AnnoP,[],A0,[],[],[]).

runAB(X)	:-	init(AnnotatedP, A0),
			executeAB(AnnotatedP, [], A0, [], [], [], 1, X). 

runABall(X)	:-	init(AnnotatedP, A0),
			executeABall(AnnotatedP, [], A0, [], [], [], 1, X). 

runAB(silent,one,X) 	:- 	nl, write('Executing in silent mode!'), nl, nl, runAB(X).
runAB(noisy,one,X) 	:- 	nl, write('Executing in noisy mode!'), nl, nl, runAB(X).
runAB(silent,all,X) 	:- 	nl, write('Executing in silent mode!'), nl, nl, runABall(X).
runAB(noisy,all,X) 	:- 	nl, write('Executing in noisy mode!'), nl, nl, runABall(X).

executeAB([],[],A,_,_,_,_,X) 	:- 	write('FINISHED, the defence set is: '), 
					remove_duplicates(A,X), 
					write(X), nl, nl.
executeAB(A,B,C,D,Arg,Rel,N,Y) 	:- 	execOneAB((A,B,C,D,Arg,Rel),(A2,B2,C2,D2,Arg2,Rel2)),
					mwrite('Step '), mwrite(N), mwrite(': '), N1 is N + 1,
					writeStructQuad(A2,B2,C2,D2,Arg2,Rel2), 
					executeAB(A2,B2,C2,D2,Arg2,Rel2,N1,Y). 

executeABall([],[],A,_,_,_,_,X) 	:- 	write('FINISHED, one defence set is: '),
					remove_duplicates(A,X),
					write(X),nl,nl,fail.
executeABall(A,B,C,D,Arg,Rel,N,Y) :- 	execOneAB((A,B,C,D,Arg,Rel),(A2,B2,C2,D2,Arg2,Rel2)),
					mwrite('Step '), mwrite(N), mwrite(': '), N1 is N + 1,
					writeStructQuad(A2,B2,C2,D2,Arg2,Rel2), 
					executeABall(A2,B2,C2,D2,Arg2,Rel2,N1,Y). 


execOneAB((P,O,A,C,Arg,Rel),(P2,O2,A2,C2,Arg2,Rel2)) 	:-  
		selectPlayer(P,O,PlayerChoice),
		( PlayerChoice = selectFromP	->
			%%% the proponent gets to expand ...
			selectArgument(P,SelectedStruct,Rest),
			SelectedStruct = info(_,_,_,unmarked(PUM),_),
			selectionFunction(PUM,Omega),
			( myAsm(Omega)	->
				mwrite('CASE 1'),mnl,
				executeCase1(SelectedStruct,Rest,Omega,(P,O,A,C,Arg,Rel),(P2,O2,A2,C2,Arg2,Rel2))	
			;
				mwrite('CASE 2'),mnl,
				executeCase2(SelectedStruct,Rest,Omega,(P,O,A,C,Arg,Rel),(P2,O2,A2,C2,Arg2,Rel2))	
			)
		;
			%%% the opponent gets to expand
			selectArgument(O,SelectedStruct,Rest),
			SelectedStruct = info(_,_,_,unmarked(PUM),_),
			selectionFunction(PUM,Omega),
			( myAsm(Omega)	->
			    (
				( member(Omega,C)	->
					mwrite('CASE 3b'),mnl,
					executeCase3b(SelectedStruct,Rest,Omega,(P,O,A,C,Arg,Rel),(P2,O2,A2,C2,Arg2,Rel2))
				;
					mwrite('CASE 3c'),mnl,
					executeCase3c(SelectedStruct,Rest,Omega,(P,O,A,C,Arg,Rel),(P2,O2,A2,C2,Arg2,Rel2))
				)
			    ;
				(
					mwrite('CASE 3a - ignoring '), mwrite(Omega), mnl,
					executeCase3a(SelectedStruct,Rest,Omega,(P,O,A,C,Arg,Rel),(P2,O2,A2,C2,Arg2,Rel2))
				)
			    )
			;
				mwrite('CASE 4'),mnl,
				executeCase4(SelectedStruct,Rest,Omega,(P,O,A,C,Arg,Rel),(P2,O2,A2,C2,Arg2,Rel2))	
			)
		).						

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Basically just going though the cases of the  AB DISPUTE DERIVATIONS                     %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%  Case 1: P's turn ... Omega is an assumption 

%%% In the latter case, we need to mark the selected assumption Omega but leave it in P2
%%% We do not need to make a note of it in A2 since that happened in 1(i) before. 

executeCase1(SelectedStruct,PRest,Omega,(_,O,D,C,Arg,Rel), (P2,O2,D,C,Arg2,Rel2)) :- 
		SelectedStruct = info(localG(LG),argN(ArgNum),attacks(ATT),unmarked(PUM),marked(PM)),
	% augment Oi
		findall( Info, 
			 (	contrary(Omega,X),
				getNewArgNumber(N1),	
				Info = info(localG(X),argN(N1),attacks(ArgNum),unmarked([X]),marked([]))
			  ),
			  ListStructsContraries),
		append(O,ListStructsContraries,O2),
	% if this was the last element, built trivial arg.
		select(Omega,PUM,PUMNew),
		append(PM,[Omega],PMNew),
		( PUMNew = []	->
			(	
				P2 = PRest, 
				append(Arg,[argument(ArgNum,[],PMNew,LG)],Arg2), 
				append(Rel,[attacks(ArgNum,ATT)],Rel2) 
			)
		;
			(	
				P2 = [info(localG(LG),argN(ArgNum),attacks(ATT),unmarked(PUMNew),marked(PMNew))|PRest],
				Arg2=Arg,
				Rel2=Rel
			)
		).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%  Case 2: P's turn ... Omega is NOT an assumption 

executeCase2(SelectedStruct,PRest,Omega,(_,O,D,C,Arg,Rel), (P2,O,D2,C,Arg2,Rel2)) :- 
 		SelectedStruct = info(localG(LG),argN(ArgNum),attacks(ATT),unmarked(PUM),marked(PM)),
		findR(Omega,C,R),
	% augment Di
		getAssumptionsAsList(AsmL),
		intersectLists(AsmL,R,InterSected),  % HERE THE BAD BINDING HAPPENS IN VAR CASE
 		append(D,InterSected,D2), 
	% remove from R those sentence that are already in the defense set
		filterR(R,D,FilteredR),			
		select(Omega,PUM,PUMTemp),		
		append(PUMTemp,FilteredR,PUMNew),	
	% if this was the last element and a fact, hence no new elems added and PUMNew empty, then built trivial arg.
	% or if this was a rule, but all things on RHS are already in the defence set
		( PUMNew = []	->
			(	
				P2 = PRest, 
				append(PM,R,PMwithR),
				append(Arg,[argument(ArgNum,[],PMwithR,LG)],Arg2), 
				append(Rel,[attacks(ArgNum,ATT)],Rel2) 
			)
		;
			(	
				intersectLists(R,D,X5),
				append(PM,X5,PMNew), 
				P2 = [info(localG(LG),argN(ArgNum),attacks(ATT),unmarked(PUMNew),marked(PMNew))|PRest],
				Arg2=Arg,
				Rel2=Rel
			)
		).		

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
									
%%%  Case 3 a) ... S from O and Omega from S ... Omega is assumption ... and ignored.

executeCase3a(SelectedStruct,ORest,Omega,(P,_,D,C,Arg,Rel), (P,O2,D,C,Arg,Rel)) :- 	
		SelectedStruct = info(LG,AN,AT,unmarked(OUM),marked(OM)),	
		select(Omega,OUM,OUMNew),
		append(OM,[Omega],OMNew),
		NewStruct = info(LG,AN,AT,unmarked(OUMNew),marked(OMNew)),	
		append(ORest,[NewStruct],O2).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%  Case 3 b) ... S from O and Omega from S ... Omega is assumption ... not in A, but in C.

executeCase3b(SelectedStruct,ORest,Omega,(P,_,D,C,Arg,Rel), (P,ORest,D,C,Arg2,Rel2)) :-	
	% here we need to change Arg and Rel
		\+ member(Omega,D), % should always be the case when we get here !!!
		SelectedStruct = info(localG(LG),argN(ArgNum),attacks(ATT),unmarked(OUM),marked(OM)),
	% build premise of potential argument here ... mix of OM and (assumptions in) OUM ... MAYBE?
%		append(OUM,OM,Premise), % will include Omega
select(Omega,OUM,OUMTemp),
append(OM,[Omega],OMTemp),
		append(Arg,[argument(ArgNum,OUMTemp,OMTemp,LG)],Arg2),
		append(Rel,[attacks(ArgNum,ATT)],RelTemp),
contrary(Omega,X),		
findSomeLabel(X,Arg,P,SomeLabel),
		append(RelTemp,[attacks(SomeLabel,ArgNum)],Rel2).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% Case 3 c) ... joining the two subcases 2ic1 and 2ic2

executeCase3c(SelectedStruct,ORest,Omega,(P,_,D,C,Arg,Rel), (P2,ORest,D2,C2,Arg2,Rel2)) :-		
		contrary(Omega,OmegaBar),	
	% augment C
		append(C,[Omega],C2),
% add to D
getAssumptionsAsList(AsmL),
intersectLists(AsmL,[OmegaBar],InterSectedA), 
append(D,InterSectedA,D2),
	% augment P - by choosing one of the contraries of Omega for P to prove ... backtracking will try them all
		SelectedStruct = info(localG(LGOld),argN(ArgNOld),attacks(ATT),unmarked(OUM),marked(OM)),
		getNewArgNumber(N1),
		NewPStruct = info(localG(OmegaBar),argN(N1),attacks(ArgNOld),unmarked([OmegaBar]),marked([])),
		append(P, [NewPStruct], P2),
	% build premise of potential argument here ... mix of OM and (assumptions in) OUM ... MAYBE?
%		append(OUM,OM,Premise),	%will include Omega
select(Omega,OUM,OUMTemp),
append(OM,[Omega],OMTemp),
		append(Arg, [argument(ArgNOld, OUMTemp,OMTemp , LGOld)] , Arg2),
		append(Rel, [attacks(ArgNOld,ATT)] , Rel2).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% Case 4 ... opponent chose a non-assumption

executeCase4(SelectedStruct,ORest,Omega,(P,_,D,C,Arg,Rel), (P,O2,D,C,Arg2,Rel2)) :-	
	% we need to change Arg and Rel ... and Rel maybe twice 
		SelectedStruct = info(localG(LG),argN(ArgNum),attacks(ATT),unmarked(OUM),marked(OM)),					select(Omega,OUM,OUMTemp),
		findall( X,	
			(	myRule(Omega,RHS), 
			 	intersectLists(C,RHS,[]),
				append(OUMTemp,RHS,OUMNew),				
				X = info(localG(LG),argN(ArgNum),attacks(ATT),unmarked(OUMNew),marked(OM))	
			),
			ONew),
		possiblyModifyArgNums(ONew,ONewMod),
		append(ORest,ONewMod,O2),
findall(RHSide,
	(	myRule(Omega,RHSide),	
		intersectLists(C,RHSide,[_|_])	
	),
	ListOfRHSs),
% for all elements in ListOfRHSs, we must build an new arg with label n, add n->ATT to rel and add x->n to % rel such that x is found using someLabel 
handleCase4aux(ListOfRHSs,C,OUMTemp,OM,LG,ATT,P,Arg,Rel,Arg2,Rel2).

%handleCase4aux(ListIn,CIn,OUMTempIn,OMIn,LGIn,ATTIn,PIn,ArgIn,RelIn,ArgOut,RelOut) ...
handleCase4aux([],_,_,_,_,_,_,Arg,Rel,Arg,Rel).
handleCase4aux([R|Rest],C,OUMTemp,OM,LG,ATT,P,Arg,Rel,Arg2,Rel2) :-
	filterR(R,C,FilteredR),
	append(OUMTemp,FilteredR,OUMResult),
	intersectLists(C,R,IntersectResult),
	append(OM,IntersectResult,OMResult),
	getNewArgNumber(NewNumber),
	member(Culpi,IntersectResult),
	contrary(Culpi,ConOfCulpi),
	findSomeLabel(ConOfCulpi,Arg,P,SomeLabel),
	append(Arg, [argument(NewNumber,OUMResult,OMResult,LG)] , ArgTemp),
	append(Rel, [attacks(NewNumber,ATT)] , RelT1),
	append(RelT1, [attacks(SomeLabel,NewNumber)] , RelTemp),
	handleCase4aux(Rest,C,OUMTemp,OM,LG,ATT,P,ArgTemp,RelTemp,Arg2,Rel2).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%findSomeLabel(_,_,_,someLabel).
findSomeLabel(Omega,Arg,P,SomeLabel)	:-	
		( member( argument(SomeLabel,_,_,Omega) , Arg) ; member( info(localG(Omega),argN(SomeLabel),_,_,_), P) ).


findModifiedArgNum(ONewMod,ModdedArgNum)	:-
		member(X,ONewMod),
		X = info(_,argN(ModdedArgNum),_,unmarked([]),_).

possiblyModifyArgNums(L,L)		:-	length(L,LLength), ( LLength = 0 ; LLength = 1).
possiblyModifyArgNums(TheList, Result) 	:-
		length(TheList,Length),
		Length > 1,
		assert(sub_arg(1)),
		findall( X,
			(	member(M,TheList),
				M = info(LG,argN(ArgNumOld),AT,UML,ML),
				modifyArgNum(ArgNumOld,ArgNumNew),
				X = info(LG,argN(ArgNumNew),AT,UML,ML)
			),
			Result),
		retractall(sub_arg(_)).

modifyArgNum(In,Out) 	:- 
		number(In),
		retract(sub_arg(Sub)),
		InCode is In + 48,
		SubCode is Sub + 48,
		name(Out,[InCode,58,SubCode]),
		SubNew is Sub + 1,
		assert(sub_arg(SubNew)).

modifyArgNum(In,Out)	:-
		\+ number(In),
		retract(sub_arg(Sub)),
		SubCode is Sub + 48,
		name(In,InList),		
		append(InList,[58,SubCode],NewList),		
		name(Out,NewList),
		SubNew is Sub + 1,
		assert(sub_arg(SubNew)).

getNewArgNumber(N1)	:-
		user:retract(arg_number(N)),
		N1 is N + 1,
		user:assert(arg_number(N1)).

getAssumptionsAsList(L)	:- 
		findall(X,myAsm(X),L).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

myAsm(X) :- user:myAsm(X).
contrary(X,Y) :- user:contrary(X,Y).
myRule(X,Y) :- user:myRule(X,Y).
